%
% Generate the figures and tables in Section 8.3.1 of the book:
%
% Dongrui WU (dongruiw@usc.edu), 5/12/2008

clc
clear all
close all

%% get the FOUs from the IA; only return 9 words
[words,MFs,Cs]=getFOUsC8();

%% Plot the 9 ordered IT2 FS word models in a single figure ----
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',12);
set(gcf,'DefaultaxesFontSize',10);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
for i=1:size(words,1)
    subplot(5,3,i);
    fill(MFs(i,[1:4 8 7 6 5 1]),[0 1 1 0 0 MFs(i,9) MFs(i,9) 0 0],[0.9 0.9 0.9]);
    hold on;
    plot(MFs(i,1:4),[0 1 1 0],'k');
    plot(MFs(i,5:8),[0 MFs(i,9) MFs(i,9) 0],'k');
    title(words(i,:),'fontsize',12);
    set(gca,'YTick',[]);
    set(gca,'XTick',[]);
    axis([0 10 0 1]);
end
saveas(gcf,'Fig8-1.eps');

%% Construct the rulebase
subsetSurvey=[1 4 5 8 9]; %% indices of the five words used in the survey
antMFsSurvey=MFs(subsetSurvey,:);
CsSurvey=Cs(subsetSurvey); %% centers of centroid of the five words in the survey
names=['1. None to very little (NVL)'
    '         2. Some (S)        '
    '  3. Moderate amount (MOA)  '
    '    4. Large amount (LA)    '
    '   5. Maximum amount (MAA)  ']; %% names of the five words in the survey

namesA5={'NVL'     ' S '     'MOA'     'LA '     'MAA'};
namesA9={'NVL'  'AB' 'SS'   ' S '     'MOA' 'GA'  'CA'  'LA '  'MAA'};

histogram=[42 3 2 0 0
    33 12 0 2 0
    12 16 15 3 1
    3 6 11 25 2
    3 6 8 22 8]; %% survey histrogram

%% without pre-processing
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',12);
set(gcf,'DefaultaxesFontSize',10);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
for k=1:length(subsetSurvey)
    [YU,UU,YL,UL]=lwaPR(antMFsSurvey,[histogram(k,:)' histogram(k,:)'],2);
    subplot(6,5,5+k);
    fill([YU YL(length(YL):-1:1)],[UU UL(length(UL):-1:1)],[0.9 0.9 0.9]);
    hold on;
    plot([YU YL(length(UL):-1:1)],[UU UL(length(UL):-1:1)]);
    title(namesA5(k),'fontsize',12);
    set(gca,'YTick',[]);
    set(gca,'XTick',[]);
    axis([0 10 0 1]);
end
saveas(gcf,'Fig8-4b.eps');

%% Pre-processing
display('The histogram after preprocessing:');
histogram1=preprocessing(histogram,CsSurvey)

%% Compute the consequent FOUs and plot
conMFsC=zeros(length(subsetSurvey),9);
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',12);
set(gcf,'DefaultaxesFontSize',10);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
for k=1:length(subsetSurvey)
    [YU,UU,YL,UL]=lwaPR(antMFsSurvey,[histogram1(k,:)' histogram1(k,:)'],2);
    conMFsC(k,:)=[YU YL max(UL)];
    subplot(6,5,10+k);
    fill([YU YL(length(YL):-1:1)],[UU UL(length(UL):-1:1)],[0.9 0.9 0.9]);
    hold on;
    if k<4
    text('Interpreter','latex','String',['$\tilde{Y}^' num2str(k) '$'],'Position',...
        [YU(3)+.8,.8]);
    else
        text('Interpreter','latex','String',['$\tilde{Y}^' num2str(k) '$'],'Position',...
        [YU(2)-2.3,.8]);
    end
    plot([YU YL(length(UL):-1:1)],[UU UL(length(UL):-1:1)]);
    title(namesA5(k),'fontsize',12);
    set(gca,'YTick',[]);
    set(gca,'XTick',[]);
    axis([0 10 0 1]);
end
saveas(gcf,'Fig8-4a.eps');

%% %%%%%%%%%%%%%%%% PR %%%%%%%%%%%%%%%%%%%
individual=[1 2 3 5 5 8 8 8 9];
conWords=namesA9(individual);
%% Compute the consus outputs
conMFs=zeros(size(words,1),9);
for i=1:size(words,1)
    [YU,UU,YL,UL]=PR(MFs(i,:),antMFsSurvey,conMFsC);
    conMFs(i,:)=[YU YL max(UL)];
    for j=1:size(words,1)
        sim(j)=Jaccard(conMFs(i,:),MFs(j,:));
    end
    [temp,index(i)]=max(sim);
    similarity(i)=round(100*Jaccard(MFs(index(i),:),MFs(individual(i),:)))/100;
    conWords(i)=namesA9(index(i));
end

%% Plot one example of mapping
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',12);
set(gcf,'DefaultaxesFontSize',10);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
i=7;
for j=1:size(words,1)
    sim(j)=Jaccard(conMFs(i,:),MFs(j,:));
end
sim
subplot(5,2.5,i);
fill(conMFs(i,[1:4 8:-1:5 1]),[0 1 1 0 0 conMFs(i,[9 9]) 0 0],[0.9 0.9 0.9]);
hold on
fill(MFs(index(i),[1:4 8:-1:5 1]),[0 1 1 0 0 MFs(index(i),[9 9]) 0 0],[0.9 0.9 0.9]);
plot(conMFs(i,[1:4 8:-1:5 1]),[0 1 1 0 0 conMFs(i,[9 9]) 0 0],'k--');
plot(MFs(index(i),[1:4 8:-1:5 1]),[0 1 1 0 0 MFs(index(i),[9 9]) 0 0],'k');
title(namesA9(index(i)),'fontsize',12);
set(gca,'YTick',[]);
set(gca,'XTick',[]);
axis([0 10 0 1]);
saveas(gcf,'Fig8-5.eps');

[conWords' namesA9(individual)']
similarity'


